HELP2.PAS


(* QuickPascal program *)

UNIT Help2;
(**********************)
(**)    INTERFACE   (**)
(**********************)
USES Help,Dos;
TYPE
  NameStr = String[8];
  HelpSet = OBJECT
    size, number : Word;
    Data : File;
    Indx : File of WORD;
    PROCEDURE InitHelp(iSize : Word);
    FUNCTION  AddMessage(M : String):Boolean;
    FUNCTION  GetMessage(B : Word):String;
    PROCEDURE DoneWithHelp;
  END;

(**********************)
(**) IMPLEMENTATION (**)
(**********************)

  FUNCTION RandomName : NameStr;
  VAR N : Byte;
    temp : NameStr;
  BEGIN
    FOR N := 1 to 8 DO
      temp[N] := Char(random(128)+128);
    temp[0] := #8;
    RandomName := temp;
  END;

  PROCEDURE HelpSet.InitHelp(iSize:Word);
  {In a real-world application, you would deal with
   real-world problems -- already-existing filename,
   invalid filename, full disk, etc.  In order to
   keep this example short we omit that kind of checking.
  }
  VAR name : NameStr;
  BEGIN
    Randomize;
    REPEAT name := RandomName;
    UNTIL FSearch(name+'.DAT','')='';
    Assign(self.data,name+'.DAT');
    ReWrite(self.data,1);
    REPEAT name := RandomName;
    UNTIL FSearch(name+'.IDX','')='';
    Assign(self.indx,name+'.IDX');
    ReWrite(self.indx);
    self.size := iSize;
    self.number := 0;
  END;

  FUNCTION HelpSet.AddMessage(M : String):Boolean;
  VAR loc : Word;
  BEGIN
    IF self.number = self.size THEN AddMessage := FALSE
    ELSE
      BEGIN
	Inc(self.number);
	loc := FilePos(self.data);
	Write(self.indx, Loc);
	BlockWrite(self.data,M,succ(length(M)));
	AddMessage := TRUE;
      END;
  END;

  FUNCTION HelpSet.GetMessage(B : Word): String;
  VAR temp : String;
    Loc : Word;
  BEGIN
    IF B > self.number THEN GetMessage := ''
    ELSE
      BEGIN
	{Get the location from the index file}
	Seek(self.indx, pred(B));
	Read(self.indx, Loc);
	{Set the index file to receive more messages}
	Seek(self.indx, FileSize(self.indx));
	{Find and read the message itself}
	Seek(self.data, loc);
	BlockRead(self.Data,temp,1);
	BlockRead(self.data,temp[1],ord(temp[0]));
	{Set the data file to receive more messages}
	Seek(self.data, FileSize(self.data));
	GetMessage := temp;
      END;
  END;

  PROCEDURE HelpSet.DoneWithHelp;
  BEGIN
    Close(self.data);
    Erase(self.data);
    Close(self.indx);
    Erase(self.indx);
  END;

END.



